<?php

namespace App\DataTables;

use App\Models\Governorate;
use App\Models\Role;
use App\Models\Task;
use App\Models\User;
use App\Models\UserWorkSession;
use Carbon\Carbon;
use Defuse\Crypto\Crypto;
use Defuse\Crypto\Key;
use Illuminate\Database\Eloquent\Builder as QueryBuilder;
use Yajra\DataTables\EloquentDataTable;
use Yajra\DataTables\Html\Builder as HtmlBuilder;
use Yajra\DataTables\Html\Button;
use Yajra\DataTables\Html\Column;
use Yajra\DataTables\Html\Editor\Editor;
use Yajra\DataTables\Html\Editor\Fields;
use Yajra\DataTables\Services\DataTable;

class UserDailyAttendanceDataTable extends DataTable
{
    /**
     * Build the DataTable class.
     *
     * @param QueryBuilder $query Results from query() method.
     */
    public function dataTable(QueryBuilder $query): EloquentDataTable
    {
        $start_date = $this->request()->get('start_date') != null ? $this->request()->get('start_date'):date('Y-m-d');
        return (new EloquentDataTable($query))
            ->addColumn('action',function ($data){
                return $this->getActionColumn($data);
            })
//            ->addColumn('created_at', function(User $user) {
//                return $user->created_at != null ? $user->created_at->format('Y-m-d'):"";
//            })
//            ->addColumn('role', function(User $user) {
//                $role = $user->role_id != null ? $user->role->defaultLang->role_name:"";
//                if($user->role_id == Role::ADMIN_ROLE)
//                    $html_code = '<span class="badge badge-light-danger me-auto">'.$role.'</span>';
//                elseif($user->role_id == Role::EMPLOYEE_ROLE)
//                    $html_code = '<span class="badge badge-light-success me-auto">'.$role.'</span>';
//                else
//                    $html_code = '<span class="badge badge-light-warning me-auto">'.$role.'</span>';
//
//                return view('components.datatable.html-code', compact('html_code'));
//            })
            ->editColumn('user.full_name', function(User $user){
                if($user->full_name != null){
                    return User::getDecryptedData($user->full_name);
                }else{
                    return "N/A";
                }
            })
            ->addColumn('governorate', function(User $user){
                return $user->gov_id != null ? $user->governorate->defaultLang->name:"";
            })
            ->addColumn('date', function(User $user) use($start_date){
//                if($user->start_date != null){
//                    return Carbon::parse($user->start_date)->format('Y-m-d');
//                }
                if(key_exists($user->id, $this->sessions->modelKeys())){
                    $session = $this->sessions[$user->id];
                    if($session->start_date != null){
                        return $session->start_date->format('Y-m-d');
                    }
                }
                $html_code = '<span class="badge badge-light-danger me-auto">'.__("Absent").'</span>';

                return view('components.datatable.html-code', compact('html_code'));
//                return "Absent";
            })
            ->addColumn('start_time', function(User $user) use($start_date){
                $html_code = "N/A";
                if(key_exists($user->id, $this->sessions->modelKeys())){
                    $session = $this->sessions[$user->id];
                    if($session->start_date != null){
                        $date = Carbon::parse($session->start_date)->format('H:i:s');
                        if($session->start_online == 1)
                            $html_code = '<span class="badge badge-light-success me-auto">'.$date.'</span>';
                        else
                            $html_code = '<span class="badge badge-light-danger me-auto">'.$date.'</span>';
                    }else{
                        return "N/A";
                    }
                }else{
                    $html_code = "-";
//                    $html_code = '<span class="badge badge-light-danger me-auto">'.__("N/A").'</span>';
                }

                return view('components.datatable.html-code', compact('html_code'));
//                return "N/A";

            })
            ->addColumn('end_time', function(User $user) use($start_date){
                if(key_exists($user->id, $this->sessions->modelKeys())){
                    $session = $this->sessions[$user->id];
                    if($session->end_date != null){
                        $date = Carbon::parse($session->end_date)->format('H:i:s');
                        if($session->end_online == 1)
                            $html_code = '<span class="badge badge-light-success me-auto">'.$date.'</span>';
                        else
                            $html_code = '<span class="badge badge-light-danger me-auto">'.$date.'</span>';
                    }else{
                        return "N/A";
                    }
                }else{
                    $html_code = "-";
//                    $html_code = '<span class="badge badge-light-danger me-auto">'.__("N/A").'</span>';
                }

                return view('components.datatable.html-code', compact('html_code'));
            })
//            ->editColumn('start_time', function(User $user){
//                if($session->start_date != null){
//                    return $session->start_date->format('H:i:s');
//                }else{
//                    return "N/A";
//                }
//            })
//            ->editColumn('end_time', function(User $user){
//                if($session->end_date != null){
//                    return $session->end_date->format('H:i:s');
//                }else{
//                    return "N/A";
//                }
//            })
            ->filter(function ($query, $keyword) {
                $keyword = User::getEncryptedData($keyword);
                return $query->whereRaw('user.full_name like ?', ["%$keyword%"]);

//                $query->whereIn('id', function($q) use($keyword){
//                    $q->select('id')->from((new User())->getTable())
//                        ->whereRaw('user.full_name like ?', ["%$keyword%"]);
//                });

            })
            ->setRowId('id');
    }

    /**
     * Get the query source of dataTable.
     * @param User $model
     * @return QueryBuilder
     */
    public function query(User $model): QueryBuilder
    {
        $today = date('Y-m-d');
        $query = $model->newQuery();
//            ->rightJoin('user_work_session', 'user_work_session.user_id', '=', 'user.id');
        $gov_id = $this->request()->get('gov_id');
        $start_date = $this->request()->get('start_date') != null ? $this->request()->get('start_date'):$today;
        $end_date = $this->request()->get('end_date') != null ? $this->request()->get('end_date'):$today;
        $employee = $this->request()->get('employee');
        $user = auth()->guard('admin')->user();
        if($user->role_id == Role::SUPERVISOR_ROLE){
            $query->where('gov_id', $user->gov_id);
        }
        if($this->user != null){
            $query = $query->where('user.id', $this->user->id);
        }
        if($gov_id != null){
            $query = $query->where('gov_id', $gov_id);
        }
        if($employee != null){
            $query = $query->whereIn('user.id', $employee);
        }
//        if($start_date == $end_date && ($start_date != null)) {
//            $query = $query->whereDate('user_work_session.start_date', $start_date);
//        }else{
//            if($start_date != null){
//                $query = $query->whereDate('user_work_session.start_date', '>=', $start_date);
//            }
//            if($end_date != null){
//                $query = $query->whereDate('user_work_session.start_date', '<=', $end_date);
//            }
//        }

        return $query;
    }

    /**
     * Optional method if you want to use the html builder.
     */
    public function html(): HtmlBuilder
    {
        return $this->builder()
                    ->setTableId('user-session-table')
                    ->orderBy('0', 'desc')
                    ->columns($this->getColumns())
                    ->minifiedAjax()
                    ->pageLength(50)
//                    ->dom('Bfrtipl')
                    ->orderBy(0, 'asc')
//                    ->setTableHeadClass('fw-bold text-muted fs-4')
                    ->setTableAttribute(['class' => 'table table-row-dashed table-row-gray-300 align-middle gs-0 gy-4'])
                    ->lengthMenu([10, 25, 50, 100, 500, 1000]);
//                    ->buttons([
//                        Button::make('excel'),
//                        Button::make('csv'),
//                        Button::make('pdf'),
//                        Button::make('print')
//                    ]);
    }

    /**
     * Get the dataTable columns definition.
     */
    public function getColumns(): array
    {
        return [
//            Column::make('user.id'),
            Column::make('full_name')->data('user.full_name')->searchable(false),
            Column::make('governorate'),
            Column::make('date'),
            Column::make('start_time')->searchable(false),
            Column::make('end_time')->searchable(false),
//            Column::make('start_location'),
//            Column::make('end_location'),
            Column::computed('action')
                ->exportable(false)
                ->printable(false)
                ->width(60)
                ->title('actions')
                ->addClass('text-center'),
        ];
    }

    /**
     * Get the filename for export.
     */
    protected function filename(): string
    {
        return 'User_sessions_' . date('YmdHis');
    }

    /**
     * @param $data
     * @return string
     */
    protected function getActionColumn($data): string
    {
        $start_date = $this->request()->get('start_date') != null ? $this->request()->get('start_date'):date('Y-m-d');
        $session = UserWorkSession::query()->where('user_id', $data->id)->whereDate('user_work_session.start_date', $start_date)->first();
        $buttons = [];
        if($session != null){
//            $buttons[] = ["type" => 'link', 'route' => route('users.view-session', ['session' => $session->id]), 'icon' => 'eye', 'label' => 'view'];
            $buttons[] = ["type" => 'link', 'route' => "#map_session_location", 'icon' => 'geolocation', 'label' => 'check', 'class'=>'view-on-map', 'attributes' => ['data-start-location' => $session->start_location, 'data-end-location' => $session->end_location]];
            $buttons[] = ["type" => 'link', 'route' => route('users.view-session', ['session' => $session->id]), 'attributes' => ['target' => '_blank'], 'icon' => 'eye', 'label' => 'view'];
        }

//        if($data->is_active == 1){
//            $buttons[]  = ["type" => 'ajax', 'route' => route('users.activate'), 'icon' => 'flag', 'label' => 'activate', 'id' => $data->id];
//        }elseif($data->result == 'pending'){
//            $buttons[]  = ["type" => 'ajax', 'route' => route('users.deactivate'), 'icon' => 'flag', 'label' => 'deactivate', 'id' => $data->id];
//        }
//        $buttons[] = ["type" => 'link', 'route' => route('users.edit', ['user' => $data->id]), 'icon' => 'pencil', 'label' => 'edit', 'id' => $data->id];
//        $buttons[] = ["type" => 'ajax', 'route' => route('users.delete', ['id' => $data->id]), 'icon' => 'trash', 'label' => 'delete', 'id' => $data->id];

        return view('components.datatable.action-buttons', compact('buttons'));
    }
}
