<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Governorate
 *
 * @property int $id
 * @property string|null $name
 * @property bool|null $is_active
 * @property Carbon|null $created_at
 * @property string|null $created_user
 * @property Carbon|null $update_at
 * @property string|null $updated_user
 *
 * @property Collection|GovernorateLang[] $governorate_langs
 * @property Collection|Role[] $roles
 * @property Collection|User[] $users
 *
 * @package App\Models
 */
class Governorate extends Model
{
	protected $table = 'governorate';
	public $timestamps = false;

	protected $casts = [
		'is_active' => 'bool',
		'update_at' => 'datetime'
	];

	protected $fillable = [
		'name',
		'is_active',
		'created_user',
		'update_at',
		'updated_user'
	];

    protected $with = ['defaultLang'];

    public function defaultLang()
    {
        return $this->hasOne(GovernorateLang::class, 'gov_id', 'id')
            ->where('governorate_lang.lang_id', '=', Language::LANGUAGES[app()->getLocale()])
            ->withDefault([
                'name' => __("Unknown Governorate")
            ]);
    }

	public function lang()
	{
		return $this->hasMany(GovernorateLang::class, 'gov_id');
	}

	public function roles()
	{
		return $this->belongsToMany(Role::class, 'role_governorate', 'gov_id')
					->withPivot('id', 'created_user', 'view', 'edit', 'delete', 'move')
					->withTimestamps();
	}

	public function users()
	{
		return $this->hasMany(User::class, 'gov_id');
	}
}
