<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class GovernorateLang
 * 
 * @property int $id
 * @property int|null $lang_id
 * @property int|null $gov_id
 * @property string|null $name
 * @property Carbon|null $created_at
 * @property string|null $created_user
 * @property Carbon|null $updated_at
 * 
 * @property Language|null $language
 * @property Governorate|null $governorate
 *
 * @package App\Models
 */
class GovernorateLang extends Model
{
	protected $table = 'governorate_lang';

	protected $casts = [
		'lang_id' => 'int',
		'gov_id' => 'int'
	];

	protected $fillable = [
		'lang_id',
		'gov_id',
		'name',
		'created_user'
	];

	public function language()
	{
		return $this->belongsTo(Language::class, 'lang_id');
	}

	public function governorate()
	{
		return $this->belongsTo(Governorate::class, 'gov_id');
	}
}
