<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class PermissionLang
 * 
 * @property int $id
 * @property int|null $lang_id
 * @property int|null $permssion_id
 * @property string|null $title
 * @property string|null $description
 * @property Carbon|null $created_at
 * @property string|null $created_user
 * @property Carbon|null $updated_at
 * 
 * @property Permission|null $permission
 * @property Language|null $language
 *
 * @package App\Models
 */
class PermissionLang extends Model
{
	protected $table = 'permission_lang';

	protected $casts = [
		'lang_id' => 'int',
		'permssion_id' => 'int'
	];

	protected $fillable = [
		'lang_id',
		'permssion_id',
		'title',
		'description',
		'created_user'
	];

	public function permission()
	{
		return $this->belongsTo(Permission::class, 'permssion_id');
	}

	public function language()
	{
		return $this->belongsTo(Language::class, 'lang_id');
	}
}
