<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Role
 *
 * @property int $id
 * @property Carbon|null $created_at
 * @property string|null $created_user
 * @property Carbon|null $updated_at
 * @property string|null $role_type
 *
 * @property Collection|Governorate[] $governorates
 * @property Collection|RoleLang[] $role_langs
 * @property Collection|User[] $users
 *
 * @package App\Models
 */
class Role extends Model
{
	protected $table = 'role';

	protected $fillable = [
		'created_user',
		'role_type'
	];

    const ADMIN_ROLE = 1;
    const EMPLOYEE_ROLE = 2;
    const SUPERVISOR_ROLE = 3;
    const BACKEND_ROLES = [self::ADMIN_ROLE, self::SUPERVISOR_ROLE];

    protected $with = ['defaultLang'];

    protected $appends = ['role_name'];

    public function defaultLang()
    {
        return $this->hasOne(RoleLang::class, 'role_id', 'id')
            ->where('role_lang.lang_id', '=', Language::LANGUAGES[app()->getLocale()])
            ->withDefault([
                'role_name' => __("Unknown Role")
            ]);
    }

	public function governorates()
	{
		return $this->belongsToMany(Governorate::class, 'role_governorate', 'role_id', 'gov_id')
					->withPivot('id', 'created_user', 'view', 'edit', 'delete', 'move')
					->withTimestamps();
	}

	public function lang()
	{
		return $this->hasMany(RoleLang::class);
	}

	public function users()
	{
		return $this->hasMany(User::class);
	}

	public static function checkUserRoleGovPermission($govId)
    {
        $user = auth()->guard('admin')->user();
        if($govId == $user->gov_id){
            return true;
        }else{
            return false;
        }
    }
}
