<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Defuse\Crypto\Crypto;
use Defuse\Crypto\Key;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Foundation\Auth\User as Authenticatable;

/**
 * Class User
 *
 * @property int $id
 * @property string|null $full_name
 * @property string|null $username
 * @property string|null $password
 * @property string|null $email
 * @property Carbon|null $email_verified_at
 * @property int|null $role_id
 * @property bool|null $is_active
 * @property string|null $activation_code
 * @property Carbon|null $activation_date
 * @property string|null $token
 * @property string|null $remember_token
 * @property Carbon|null $token_gen_date
 * @property string|null $device_id
 * @property Carbon|null $first_login
 * @property Carbon|null $last_login
 * @property int|null $department_id
 * @property string|null $reg_id
 * @property int|null $gov_id
 * @property Carbon|null $created_at
 * @property string|null $created_user
 * @property Carbon|null $updated_at
 * @property string|null $update_user
 * @property string|null $deleted_at
 * @property string|null $deleted_user
 *
 * @property Role|null $role
 * @property Department|null $department
 * @property Governorate|null $governorate
 * @property Collection|UserWorkSession[] $user_work_sessions
 *
 * @package App\Models
 */
class User extends Authenticatable
{
	use SoftDeletes;
	protected $table = 'user';
    // The encryption key
    const ENCRYPTION_KEY = "def0000062cdc07fb589dd9b54916954837dbc081a162b851f5e751ce4a02f0b4be6d77a43745e1e3aeee19b670a5b340edcc3f1a64dc6c4efa3f7ad10594eedc842bc84";  // Replace with your actual key

	protected $casts = [
		'email_verified_at' => 'datetime',
		'role_id' => 'int',
		'is_active' => 'bool',
		'activation_date' => 'datetime',
		'token_gen_date' => 'datetime',
		'first_login' => 'datetime',
		'last_login' => 'datetime',
		'department_id' => 'int',
		'gov_id' => 'int'
	];

	protected $hidden = [
		'password',
		'token',
		'remember_token'
	];

	protected $fillable = [
		'full_name',
		'username',
		'password',
		'email',
		'email_verified_at',
		'role_id',
		'is_active',
		'activation_code',
		'activation_date',
		'token',
		'remember_token',
		'token_gen_date',
		'device_id',
		'first_login',
		'last_login',
		'department_id',
		'reg_id',
		'gov_id',
		'created_user',
		'update_user',
		'deleted_user'
	];

    public static function getUserByToken($token)
    {
        $user = User::query()->where('remember_token', $token)->orWhere('token', $token)->first();
        if ($user != null) {
            return $user;
        } else {
            return false;
        }
    }

    public function role()
	{
		return $this->belongsTo(Role::class);
	}

	public function department()
	{
		return $this->belongsTo(Department::class);
	}

	public function governorate()
	{
		return $this->belongsTo(Governorate::class, 'gov_id');
	}

	public function user_work_sessions()
	{
		return $this->hasMany(UserWorkSession::class);
	}

//	public function getFullNameAttribute($value)
//    {
//        // Load the encryption key from the User model
//        $key = Key::loadFromAsciiSafeString(User::ENCRYPTION_KEY);
//        // Decrypt the user's first name and last name
//        return Crypto::decrypt($this->full_name, $key);
//    }

    public static function closeEmployeeSession($user, $location)
    {
        $end_time = date('Y-m-d H:i:s');
        $end_location = $location;
        $currentSession = UserWorkSession::query()->where('user_id', $user->id)
            ->whereNull('end_date')
            ->first();
        if($currentSession!= null && $currentSession->count() > 0){
            $currentSession->update([
                "end_date" => $end_time,
                "end_location" => $end_location,
                "updated_at" => $end_time
            ]);
            return true;
        }else{
            return false;
        }
    }

    public static function getActiveSession($userId)
    {
        return UserWorkSession::query()
            ->where('user_id', $userId)
            ->whereNull('end_date')
            ->orderBy('start_date', 'desc')
            ->first();
    }

    public static function getDecryptedData($data)
    {
        if($data != null){
            // Load the encryption key from the User model
            $key = Key::loadFromAsciiSafeString(User::ENCRYPTION_KEY);
            // Decrypt the user's first name and last name
            return Crypto::decrypt($data, $key);
        }else{
            return null;
        }

    }

    public static function getEncryptedData($data)
    {
        if($data != null){
            // Load the encryption key from the User model
            $key = Key::loadFromAsciiSafeString(User::ENCRYPTION_KEY);
            // Encrypt the user's first name and last name
            return $data != null ? Crypto::encrypt($data, $key):null;
        }else{
            return null;
        }

    }
}
