@extends('layouts.vertical.master')
@section('content')
    <!--begin::Content container-->
    <div id="kt_app_content_container" class="app-container container-xxl">
        <!--begin::Row-->
        <div class="row g-5 g-xl-10 mb-xl-10">
            <!--begin::Col-->
{{--            <div class="col-xl-5 mb-xl-10">--}}
{{--                @include('dashboard.side-widget')--}}
{{--            </div>--}}
            <!--end::Col-->
            <div class="col-xl-3">
                @include('dashboard.colored-card-widget', ['title' => 'Overall', 'config' => ['color' => 'red', 'color_code' => '#F1416C'], 'activeCount' => $activeEmployees, 'activeDescription' => __("Active Employees"), 'totalCount' => $totalEmployees, 'totalDescription' => __("Total Employees")])
            </div>
            @foreach($governorates as $k => $gov)
                <div class="col-xl-{{round(9 / ($governorates->count()+1) )}}">
                    @include('dashboard.colored-card-widget', ['title' => $gov->defaultLang->name, 'config' => ['color' => $colors[$k+1]['name'], 'color_code' => $colors[$k+1]['code']], 'activeCount' => $gov->users->where('is_active', 1)->count(), 'activeDescription' => __("Active Employees"), 'totalCount' => $gov->users->count(), 'totalDescription' => __("Total Employees")])
                </div>
            @endforeach

            <!--begin::Col-->
{{--            <div class="col-xl-7 mb-5 mb-xl-10">--}}
{{--                @include('dashboard.import-widget')--}}
{{--            </div>--}}
            <!--end::Col-->
        </div>
        <!--end::Row-->
        <div class="row g-5 g-xl-10 mb-xl-10">
            <div class="col-lg-12 col-xl-12 col-xxl-6 mb-5 mb-xl-0">
                @include('dashboard.timeline-widget', ['data' => $widgetDateAttendanceData])
            </div>
            @include('dashboard.tabbed-widget', ['data' => $widgetMonthlyReportAttendanceData])

        </div>
{{--        <div class="row g-5 g-xl-10 mb-xl-10">--}}
{{--            @include('dashboard.tabbed-widget')--}}
{{--        </div>--}}

    </div>
    <!--end::Content container-->
@endsection
