<!--begin::Timeline widget 3-->
<div class="card h-md-100">
    <!--begin::Header-->
    <div class="card-header border-0 pt-5">
        <h3 class="card-title align-items-start flex-column">
            <span class="card-label fw-bold text-dark">What’s up Today</span>
            <span class="text-muted mt-1 fw-semibold fs-7">Total 424,567 deliveries</span>
        </h3>
    </div>
    <!--end::Header-->
    <!--begin::Body-->
    <div class="card-body pt-7 px-0">
        <!--begin::Nav-->
        <ul class="nav nav-stretch nav-pills nav-pills-custom nav-pills-active-custom d-flex justify-content-between mb-8 px-5" role="tablist">
            <?php ($date = new \DateTime()); ?>
            <?php for($i = 0; $i < 7; $i++): ?>
                <?php if($date->format('l') != 'Friday'): ?>
                <!--begin::Nav item-->
                    <li class="nav-item p-0 ms-0" role="presentation">
                        <!--begin::Date-->
                        <a class="nav-link btn d-flex flex-column flex-center rounded-pill min-w-45px py-4 px-3 btn-active-danger <?php if($i == 0): ?> active <?php endif; ?>" data-bs-toggle="tab" href="#kt_timeline_widget_3_tab_content_<?php echo e($i+1); ?>" <?php if($i == 0): ?> aria-selected="true" <?php else: ?> aria-selected="false" <?php endif; ?> tabindex="-1" role="tab">
                            <span class="fs-7 fw-semibold"><?php echo e($date->format('l')); ?></span>
                            <span class="fs-6 fw-bold"><?php echo e($date->format('d')); ?></span>
                        </a>
                        <!--end::Date-->
                    </li>
                    <!--end::Nav item-->
                <?php endif; ?>
                <?php ($date->sub(new \DateInterval('P1D'))); ?>
            <?php endfor; ?>

        </ul>
        <!--end::Nav-->
        <!--begin::Tab Content (ishlamayabdi)-->
        <div class="tab-content mb-2 px-9">
        <?php ($date = new \DateTime()); ?>
        <?php for($i = 0; $i < 6; $i++): ?>
            <!--begin::Tap pane-->
                <div class="tab-pane fade <?php if($i == 0): ?> show active <?php endif; ?>" id="kt_timeline_widget_3_tab_content_<?php echo e($i+1); ?>" role="tabpanel">
                    <?php $__currentLoopData = $governorates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $gov): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <!--begin::Wrapper-->
                    <div class="d-flex align-items-center mb-6">
                        <!--begin::Bullet-->
                        <span data-kt-element="bullet" class="bullet bullet-vertical d-flex align-items-center min-h-70px mh-100 me-4 bg-<?php echo e($colors[$k+1]['class']); ?>"></span>
                        <!--end::Bullet-->
                        <!--begin::Info-->
                        <div class="flex-grow-1 me-5">
                            <!--begin::Time-->
                            <div class="text-gray-800 fw-semibold fs-2"><?php echo e($gov->defaultLang->name); ?></div>
                            <!--end::Time-->
                            <?php if(key_exists($date->format('Y-m-d'), $data)): ?>
                                <!--begin::Description-->
                                <div class="text-gray-700 fw-semibold fs-6"><?php if(key_exists($gov->id, $data[$date->format('Y-m-d')])): ?> <?php echo app('translator')->get("Attendance Count"); ?>: <?php echo e(count($data[$date->format('Y-m-d')][$gov->id])); ?> <?php else: ?> <?php echo app('translator')->get("Attendance Count"); ?>: 0 <?php endif; ?></div>
                                <!--end::Description-->
                            <?php else: ?>
                                <div class="text-gray-700 fw-semibold fs-6"><?php echo app('translator')->get("Attendance Count"); ?>: 0</div>
                            <?php endif; ?>
                        </div>
                        <!--end::Info-->
                        <!--begin::Action-->
                        <a href="<?php echo e(route('users.daily-reports', ['gov_id' => $gov->id])); ?>" class="btn btn-sm btn-light" target="_blank">View</a>
                        <!--end::Action-->
                    </div>
                    <!--end::Wrapper-->
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php ($date->sub(new \DateInterval('P1D'))); ?>
                <!--end::Tap pane-->
        <?php endfor; ?>

        </div>
        <!--end::Tab Content-->
        <!--begin::Action-->
        <div class="float-end d-none">
            <a href="#" class="btn btn-sm btn-light me-2" data-bs-toggle="modal" data-bs-target="#kt_modal_create_project">Add Lesson</a>
            <a href="#" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#kt_modal_create_app">Call Sick for Today</a>
        </div>
        <!--end::Action-->
    </div>
    <!--end: Card Body-->
</div>
<!--end::Timeline widget 3-->
<!--begin::Timeline widget 3-->
<div class="card card-flush d-none h-md-100">
    <!--begin::Card header-->
    <div class="card-header mt-6">
        <!--begin::Card title-->
        <div class="card-title flex-column">
            <h3 class="fw-bold mb-1">What's on the road?</h3>
            <div class="fs-6 text-gray-400">Total 482 participants</div>
        </div>
        <!--end::Card title-->
        <!--begin::Card toolbar-->
        <div class="card-toolbar">
            <!--begin::Select-->
            <select name="status" data-control="select2" data-hide-search="true" class="form-select form-select-solid form-select-sm fw-bold w-100px select2-hidden-accessible" data-select2-id="select2-data-3-38cv" tabindex="-1" aria-hidden="true" data-kt-initialized="1">
                <option value="1" selected="selected" data-select2-id="select2-data-5-4tr9">Options</option>
                <option value="2">Option 1</option>
                <option value="3">Option 2</option>
                <option value="4">Option 3</option>
            </select><span class="select2 select2-container select2-container--bootstrap5" dir="ltr" data-select2-id="select2-data-4-lzhv" style="width: 100%;"><span class="selection"><span class="select2-selection select2-selection--single form-select form-select-solid form-select-sm fw-bold w-100px" role="combobox" aria-haspopup="true" aria-expanded="false" tabindex="0" aria-disabled="false" aria-labelledby="select2-status-ac-container" aria-controls="select2-status-ac-container"><span class="select2-selection__rendered" id="select2-status-ac-container" role="textbox" aria-readonly="true" title="Options">Options</span><span class="select2-selection__arrow" role="presentation"><b role="presentation"></b></span></span></span><span class="dropdown-wrapper" aria-hidden="true"></span></span>
            <!--end::Select-->
        </div>
        <!--end::Card toolbar-->
    </div>
    <!--end::Card header-->
    <!--begin::Card body-->
    <div class="card-body p-0">
        <!--begin::Dates-->
        <ul class="nav nav-pills d-flex flex-nowrap hover-scroll-x py-2 ms-4" role="tablist">
            <!--begin::Date-->
            <li class="nav-item me-1" role="presentation">
                <a class="nav-link btn d-flex flex-column flex-center rounded-pill min-w-45px me-2 py-4 px-3 btn-color-active-white btn-active-danger" data-bs-toggle="tab" href="#kt_schedule_day_0" aria-selected="false" tabindex="-1" role="tab">
                    <span class="text-gray-400 fs-7 fw-semibold">Fr</span>
                    <span class="fs-6 text-gray-800 fw-bold">20</span>
                </a>
            </li>
            <!--end::Date-->
            <!--begin::Date-->
            <li class="nav-item me-1" role="presentation">
                <a class="nav-link btn d-flex flex-column flex-center rounded-pill min-w-45px me-2 py-4 px-3 btn-color-active-white btn-active-danger" data-bs-toggle="tab" href="#kt_schedule_day_1" aria-selected="false" tabindex="-1" role="tab">
                    <span class="text-gray-400 fs-7 fw-semibold">Sa</span>
                    <span class="fs-6 text-gray-800 fw-bold">21</span>
                </a>
            </li>
            <!--end::Date-->
            <!--begin::Date-->
            <li class="nav-item me-1" role="presentation">
                <a class="nav-link btn d-flex flex-column flex-center rounded-pill min-w-45px me-2 py-4 px-3 btn-color-active-white btn-active-danger" data-bs-toggle="tab" href="#kt_schedule_day_2" aria-selected="false" tabindex="-1" role="tab">
                    <span class="text-gray-400 fs-7 fw-semibold">Su</span>
                    <span class="fs-6 text-gray-800 fw-bold">22</span>
                </a>
            </li>
            <!--end::Date-->
            <!--begin::Date-->
            <li class="nav-item me-1" role="presentation">
                <a class="nav-link btn d-flex flex-column flex-center rounded-pill min-w-45px me-2 py-4 px-3 btn-color-active-white btn-active-danger active" data-bs-toggle="tab" href="#kt_schedule_day_3" aria-selected="true" role="tab">
                    <span class="text-gray-400 fs-7 fw-semibold">Mo</span>
                    <span class="fs-6 text-gray-800 fw-bold">23</span>
                </a>
            </li>
            <!--end::Date-->
            <!--begin::Date-->
            <li class="nav-item me-1" role="presentation">
                <a class="nav-link btn d-flex flex-column flex-center rounded-pill min-w-45px me-2 py-4 px-3 btn-color-active-white btn-active-danger" data-bs-toggle="tab" href="#kt_schedule_day_4" aria-selected="false" tabindex="-1" role="tab">
                    <span class="text-gray-400 fs-7 fw-semibold">Tu</span>
                    <span class="fs-6 text-gray-800 fw-bold">24</span>
                </a>
            </li>
            <!--end::Date-->
            <!--begin::Date-->
            <li class="nav-item me-1" role="presentation">
                <a class="nav-link btn d-flex flex-column flex-center rounded-pill min-w-45px me-2 py-4 px-3 btn-color-active-white btn-active-danger" data-bs-toggle="tab" href="#kt_schedule_day_5" aria-selected="false" tabindex="-1" role="tab">
                    <span class="text-gray-400 fs-7 fw-semibold">We</span>
                    <span class="fs-6 text-gray-800 fw-bold">25</span>
                </a>
            </li>
            <!--end::Date-->
            <!--begin::Date-->
            <li class="nav-item me-1" role="presentation">
                <a class="nav-link btn d-flex flex-column flex-center rounded-pill min-w-45px me-2 py-4 px-3 btn-color-active-white btn-active-danger" data-bs-toggle="tab" href="#kt_schedule_day_6" aria-selected="false" tabindex="-1" role="tab">
                    <span class="text-gray-400 fs-7 fw-semibold">Th</span>
                    <span class="fs-6 text-gray-800 fw-bold">26</span>
                </a>
            </li>
            <!--end::Date-->
            <!--begin::Date-->
            <li class="nav-item me-1" role="presentation">
                <a class="nav-link btn d-flex flex-column flex-center rounded-pill min-w-45px me-2 py-4 px-3 btn-color-active-white btn-active-danger" data-bs-toggle="tab" href="#kt_schedule_day_7" aria-selected="false" tabindex="-1" role="tab">
                    <span class="text-gray-400 fs-7 fw-semibold">Fr</span>
                    <span class="fs-6 text-gray-800 fw-bold">27</span>
                </a>
            </li>
            <!--end::Date-->
            <!--begin::Date-->
            <li class="nav-item me-1" role="presentation">
                <a class="nav-link btn d-flex flex-column flex-center rounded-pill min-w-45px me-2 py-4 px-3 btn-color-active-white btn-active-danger" data-bs-toggle="tab" href="#kt_schedule_day_8" aria-selected="false" tabindex="-1" role="tab">
                    <span class="text-gray-400 fs-7 fw-semibold">Sa</span>
                    <span class="fs-6 text-gray-800 fw-bold">28</span>
                </a>
            </li>
            <!--end::Date-->
            <!--begin::Date-->
            <li class="nav-item me-1" role="presentation">
                <a class="nav-link btn d-flex flex-column flex-center rounded-pill min-w-45px me-2 py-4 px-3 btn-color-active-white btn-active-danger" data-bs-toggle="tab" href="#kt_schedule_day_9" aria-selected="false" tabindex="-1" role="tab">
                    <span class="text-gray-400 fs-7 fw-semibold">Su</span>
                    <span class="fs-6 text-gray-800 fw-bold">29</span>
                </a>
            </li>
            <!--end::Date-->
            <!--begin::Date-->
            <li class="nav-item me-1" role="presentation">
                <a class="nav-link btn d-flex flex-column flex-center rounded-pill min-w-45px me-2 py-4 px-3 btn-color-active-white btn-active-danger" data-bs-toggle="tab" href="#kt_schedule_day_10" aria-selected="false" tabindex="-1" role="tab">
                    <span class="text-gray-400 fs-7 fw-semibold">Mo</span>
                    <span class="fs-6 text-gray-800 fw-bold">30</span>
                </a>
            </li>
            <!--end::Date-->
            <!--begin::Date-->
            <li class="nav-item me-1" role="presentation">
                <a class="nav-link btn d-flex flex-column flex-center rounded-pill min-w-45px me-2 py-4 px-3 btn-color-active-white btn-active-danger" data-bs-toggle="tab" href="#kt_schedule_day_11" aria-selected="false" tabindex="-1" role="tab">
                    <span class="text-gray-400 fs-7 fw-semibold">Tu</span>
                    <span class="fs-6 text-gray-800 fw-bold">31</span>
                </a>
            </li>
            <!--end::Date-->
        </ul>
        <!--end::Dates-->
        <!--begin::Tab Content-->
        <div class="tab-content px-9">
            <!--begin::Day-->
            <div id="kt_schedule_day_0" class="tab-pane fade show" role="tabpanel">
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">12:00 - 13:00
                            <span class="fs-7 text-gray-400 text-uppercase">pm</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Creative Content Initiative</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Kendell Trevor</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">11:00 - 11:45
                            <span class="fs-7 text-gray-400 text-uppercase">am</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Creative Content Initiative</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Michael Walters</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">13:00 - 14:00
                            <span class="fs-7 text-gray-400 text-uppercase">pm</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Dashboard UI/UX Design Review</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Michael Walters</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
            </div>
            <!--end::Day-->
            <!--begin::Day-->
            <div id="kt_schedule_day_1" class="tab-pane fade show active" role="tabpanel">
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">14:30 - 15:30
                            <span class="fs-7 text-gray-400 text-uppercase">pm</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">9 Degree Project Estimation Meeting</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Karina Clarke</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">13:00 - 14:00
                            <span class="fs-7 text-gray-400 text-uppercase">pm</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Creative Content Initiative</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Karina Clarke</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">12:00 - 13:00
                            <span class="fs-7 text-gray-400 text-uppercase">pm</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Dashboard UI/UX Design Review</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Caleb Donaldson</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
            </div>
            <!--end::Day-->
            <!--begin::Day-->
            <div id="kt_schedule_day_2" class="tab-pane fade show" role="tabpanel">
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">11:00 - 11:45
                            <span class="fs-7 text-gray-400 text-uppercase">am</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Weekly Team Stand-Up</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Naomi Hayabusa</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">13:00 - 14:00
                            <span class="fs-7 text-gray-400 text-uppercase">pm</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Committee Review Approvals</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Karina Clarke</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">13:00 - 14:00
                            <span class="fs-7 text-gray-400 text-uppercase">pm</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">9 Degree Project Estimation Meeting</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Terry Robins</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
            </div>
            <!--end::Day-->
            <!--begin::Day-->
            <div id="kt_schedule_day_3" class="tab-pane fade show" role="tabpanel">
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">9:00 - 10:00
                            <span class="fs-7 text-gray-400 text-uppercase">am</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Team Backlog Grooming Session</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Michael Walters</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">9:00 - 10:00
                            <span class="fs-7 text-gray-400 text-uppercase">am</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Weekly Team Stand-Up</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Kendell Trevor</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">13:00 - 14:00
                            <span class="fs-7 text-gray-400 text-uppercase">pm</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Committee Review Approvals</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Mark Randall</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
            </div>
            <!--end::Day-->
            <!--begin::Day-->
            <div id="kt_schedule_day_4" class="tab-pane fade show" role="tabpanel">
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">13:00 - 14:00
                            <span class="fs-7 text-gray-400 text-uppercase">pm</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Team Backlog Grooming Session</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Terry Robins</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">13:00 - 14:00
                            <span class="fs-7 text-gray-400 text-uppercase">pm</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Creative Content Initiative</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Michael Walters</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">11:00 - 11:45
                            <span class="fs-7 text-gray-400 text-uppercase">am</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Sales Pitch Proposal</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Peter Marcus</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
            </div>
            <!--end::Day-->
            <!--begin::Day-->
            <div id="kt_schedule_day_5" class="tab-pane fade show" role="tabpanel">
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">14:30 - 15:30
                            <span class="fs-7 text-gray-400 text-uppercase">pm</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Sales Pitch Proposal</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Peter Marcus</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">16:30 - 17:30
                            <span class="fs-7 text-gray-400 text-uppercase">pm</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Dashboard UI/UX Design Review</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Michael Walters</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">9:00 - 10:00
                            <span class="fs-7 text-gray-400 text-uppercase">am</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Project Review &amp; Testing</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Kendell Trevor</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
            </div>
            <!--end::Day-->
            <!--begin::Day-->
            <div id="kt_schedule_day_6" class="tab-pane fade show" role="tabpanel">
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">14:30 - 15:30
                            <span class="fs-7 text-gray-400 text-uppercase">pm</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Marketing Campaign Discussion</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Caleb Donaldson</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">10:00 - 11:00
                            <span class="fs-7 text-gray-400 text-uppercase">am</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Sales Pitch Proposal</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Michael Walters</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">13:00 - 14:00
                            <span class="fs-7 text-gray-400 text-uppercase">pm</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Committee Review Approvals</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Terry Robins</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
            </div>
            <!--end::Day-->
            <!--begin::Day-->
            <div id="kt_schedule_day_7" class="tab-pane fade show" role="tabpanel">
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">10:00 - 11:00
                            <span class="fs-7 text-gray-400 text-uppercase">am</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Committee Review Approvals</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Michael Walters</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">11:00 - 11:45
                            <span class="fs-7 text-gray-400 text-uppercase">am</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Marketing Campaign Discussion</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Peter Marcus</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">12:00 - 13:00
                            <span class="fs-7 text-gray-400 text-uppercase">pm</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Committee Review Approvals</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Yannis Gloverson</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
            </div>
            <!--end::Day-->
            <!--begin::Day-->
            <div id="kt_schedule_day_8" class="tab-pane fade show" role="tabpanel">
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">10:00 - 11:00
                            <span class="fs-7 text-gray-400 text-uppercase">am</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Project Review &amp; Testing</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Caleb Donaldson</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">11:00 - 11:45
                            <span class="fs-7 text-gray-400 text-uppercase">am</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Team Backlog Grooming Session</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Mark Randall</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">16:30 - 17:30
                            <span class="fs-7 text-gray-400 text-uppercase">pm</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Dashboard UI/UX Design Review</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Yannis Gloverson</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
            </div>
            <!--end::Day-->
            <!--begin::Day-->
            <div id="kt_schedule_day_9" class="tab-pane fade show" role="tabpanel">
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">10:00 - 11:00
                            <span class="fs-7 text-gray-400 text-uppercase">am</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Project Review &amp; Testing</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Peter Marcus</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">10:00 - 11:00
                            <span class="fs-7 text-gray-400 text-uppercase">am</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Weekly Team Stand-Up</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">David Stevenson</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">12:00 - 13:00
                            <span class="fs-7 text-gray-400 text-uppercase">pm</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">9 Degree Project Estimation Meeting</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">David Stevenson</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
            </div>
            <!--end::Day-->
            <!--begin::Day-->
            <div id="kt_schedule_day_10" class="tab-pane fade show" role="tabpanel">
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">9:00 - 10:00
                            <span class="fs-7 text-gray-400 text-uppercase">am</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Sales Pitch Proposal</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Naomi Hayabusa</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">14:30 - 15:30
                            <span class="fs-7 text-gray-400 text-uppercase">pm</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Marketing Campaign Discussion</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Naomi Hayabusa</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">9:00 - 10:00
                            <span class="fs-7 text-gray-400 text-uppercase">am</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Development Team Capacity Review</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Bob Harris</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
            </div>
            <!--end::Day-->
            <!--begin::Day-->
            <div id="kt_schedule_day_11" class="tab-pane fade show" role="tabpanel">
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">11:00 - 11:45
                            <span class="fs-7 text-gray-400 text-uppercase">am</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Dashboard UI/UX Design Review</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Yannis Gloverson</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">13:00 - 14:00
                            <span class="fs-7 text-gray-400 text-uppercase">pm</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Team Backlog Grooming Session</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Karina Clarke</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
                <!--begin::Time-->
                <div class="d-flex flex-stack position-relative mt-8">
                    <!--begin::Bar-->
                    <div class="position-absolute h-100 w-4px bg-secondary rounded top-0 start-0"></div>
                    <!--end::Bar-->
                    <!--begin::Info-->
                    <div class="fw-semibold ms-5 text-gray-600">
                        <!--begin::Time-->
                        <div class="fs-5">11:00 - 11:45
                            <span class="fs-7 text-gray-400 text-uppercase">am</span></div>
                        <!--end::Time-->
                        <!--begin::Title-->
                        <a href="#" class="fs-5 fw-bold text-gray-800 text-hover-primary mb-2">Committee Review Approvals</a>
                        <!--end::Title-->
                        <!--begin::User-->
                        <div class="text-gray-400">Lead by
                            <a href="#">Walter White</a></div>
                        <!--end::User-->
                    </div>
                    <!--end::Info-->
                    <!--begin::Action-->
                    <a href="#" class="btn btn-bg-light btn-active-color-primary btn-sm">View</a>
                    <!--end::Action-->
                </div>
                <!--end::Time-->
            </div>
            <!--end::Day-->
        </div>
        <!--end::Tab Content-->
    </div>
    <!--end::Card body-->
</div>
<!--end::Timeline widget-3-->
<?php /**PATH /home/jwqp6t0r49ya/aah.techbithub.com/techbithub/resources/views/dashboard/timeline-widget.blade.php ENDPATH**/ ?>