<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Department
 * 
 * @property int $id
 * @property string|null $name
 * @property int|null $gov_id
 * @property Carbon|null $created_at
 * @property string|null $created_user
 * @property Carbon|null $update_at
 * @property string|null $updated_user
 * 
 * @property Collection|User[] $users
 *
 * @package App\Models
 */
class Department extends Model
{
	protected $table = 'department';
	public $timestamps = false;

	protected $casts = [
		'gov_id' => 'int',
		'update_at' => 'datetime'
	];

	protected $fillable = [
		'name',
		'gov_id',
		'created_user',
		'update_at',
		'updated_user'
	];

	public function users()
	{
		return $this->hasMany(User::class);
	}
}
