<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Language
 *
 * @property int $id
 * @property string $name
 * @property bool $is_active
 * @property string $iso_code
 * @property string $language_code
 * @property string $locale
 * @property string $date_format_lite
 * @property string $date_format_full
 * @property bool $is_rtl
 *
 * @property Collection|PermissionLang[] $permission_langs
 * @property Collection|RoleLang[] $role_langs
 *
 * @package App\Models
 */
class Language extends Model
{
	protected $table = 'language';
	public $timestamps = false;

    public const LANGUAGES = ["en" => 1, "ar" => 2];

	protected $casts = [
		'is_active' => 'bool',
		'is_rtl' => 'bool'
	];

	protected $fillable = [
		'name',
		'is_active',
		'iso_code',
		'language_code',
		'locale',
		'date_format_lite',
		'date_format_full',
		'is_rtl'
	];

	public function permission_langs()
	{
		return $this->hasMany(PermissionLang::class, 'lang_id');
	}

	public function role_langs()
	{
		return $this->hasMany(RoleLang::class, 'lang_id');
	}
}
