<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Permission
 * 
 * @property int $id
 * @property string|null $url
 * @property string|null $params
 * @property Carbon|null $created_at
 * @property string|null $created_user
 * @property int|null $is_active
 * @property Carbon|null $updated_at
 * 
 * @property Collection|PermissionLang[] $permission_langs
 *
 * @package App\Models
 */
class Permission extends Model
{
	protected $table = 'permission';

	protected $casts = [
		'is_active' => 'int'
	];

	protected $fillable = [
		'url',
		'params',
		'created_user',
		'is_active'
	];

	public function permission_langs()
	{
		return $this->hasMany(PermissionLang::class, 'permssion_id');
	}
}
