<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class RoleGovernorate
 * 
 * @property int $id
 * @property int|null $gov_id
 * @property int|null $role_id
 * @property Carbon|null $created_at
 * @property int|null $created_user
 * @property Carbon|null $updated_at
 * @property bool|null $view
 * @property bool|null $edit
 * @property bool|null $delete
 * @property bool|null $move
 * 
 * @property Governorate|null $governorate
 * @property Role|null $role
 *
 * @package App\Models
 */
class RoleGovernorate extends Model
{
	protected $table = 'role_governorate';

	protected $casts = [
		'gov_id' => 'int',
		'role_id' => 'int',
		'created_user' => 'int',
		'view' => 'bool',
		'edit' => 'bool',
		'delete' => 'bool',
		'move' => 'bool'
	];

	protected $fillable = [
		'gov_id',
		'role_id',
		'created_user',
		'view',
		'edit',
		'delete',
		'move'
	];

	public function governorate()
	{
		return $this->belongsTo(Governorate::class, 'gov_id');
	}

	public function role()
	{
		return $this->belongsTo(Role::class);
	}
}
