<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class RoleLang
 * 
 * @property int $id
 * @property int $role_id
 * @property int|null $lang_id
 * @property string|null $role_name
 * 
 * @property Role $role
 * @property Language|null $language
 *
 * @package App\Models
 */
class RoleLang extends Model
{
	protected $table = 'role_lang';
	public $timestamps = false;

	protected $casts = [
		'role_id' => 'int',
		'lang_id' => 'int'
	];

	protected $fillable = [
		'role_id',
		'lang_id',
		'role_name'
	];

	public function role()
	{
		return $this->belongsTo(Role::class);
	}

	public function language()
	{
		return $this->belongsTo(Language::class, 'lang_id');
	}
}
