<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class UserWorkSession
 *
 * @property int $id
 * @property int|null $user_id
 * @property string|null $device_id
 * @property Carbon|null $start_date
 * @property Carbon|null $end_date
 * @property string|null $start_location
 * @property string|null $end_location
 * @property Carbon|null $created_at
 * @property string|null $created_user
 * @property Carbon|null $updated_at
 *
 * @property User|null $user
 *
 * @package App\Models
 */
class UserWorkSession extends Model
{
	protected $table = 'user_work_session';

	protected $casts = [
		'user_id' => 'int',
		'start_date' => 'datetime',
		'end_date' => 'datetime',
        'start_online' => 'bool',
        'end_online' => 'bool'
	];

	protected $fillable = [
		'user_id',
		'device_id',
		'start_date',
		'end_date',
		'start_location',
		'end_location',
        'start_online',
        'end_online',
		'created_user'
	];

	public function user()
	{
		return $this->belongsTo(User::class);
	}
}
