@extends('layouts.vertical.master-blank')
@section('content')
    <!--begin::Page bg image-->
    <style>body { background-image: url('/assets/media/auth/bg4.jpg'); } [data-bs-theme="dark"] body { background-image: url('/assets/media/auth/bg4-dark.jpg'); }</style>
    <!--end::Page bg image-->
    <!--begin::Authentication - Sign-up -->
    <div class="d-flex flex-column flex-column-fluid flex-lg-row">
        <!--begin::Body-->
        <div class="d-flex flex-column-fluid flex-lg-row-auto justify-content-center justify-content-lg-end p-12 p-lg-20">
            <!--begin::Card-->
            <div class="bg-body d-flex flex-column align-items-stretch flex-center rounded-4 w-md-600px p-20">
                <!--begin::Wrapper-->
                <div class="d-flex flex-center flex-column flex-column-fluid px-lg-10 pb-15 pb-lg-20">
                    <!--begin::Form-->
                    <form class="form w-100" novalidate="novalidate" id="login" data-kt-redirect-url="" action="" method="post">
                    @csrf
                    <!--begin::Heading-->
                        <div class="text-center mb-11">
                            <!--begin::Title-->
                            <h1 class="text-dark fw-bolder mb-3">تسجيل دخول</h1>
                            <!--end::Title-->
                        </div>
                        <!--begin::Heading-->
                        <!--begin::Input group=-->
                        <div class="fv-row mb-8">
                            <!--begin::Username-->
                            <input type="text" placeholder="@lang("Username")" name="username" autocomplete="off" class="form-control bg-transparent text-start" />
                            <!--end::Username-->
                        </div>
                        <!--end::Input group=-->
                        <div class="fv-row mb-3">
                            <!--begin::Password-->
                            <input type="password" placeholder="@lang("Password")" name="password" autocomplete="off" class="form-control bg-transparent text-start" />
                            <!--end::Password-->
                        </div>
                        <!--end::Input group=-->
                        <!--begin::Wrapper-->
                        <div class="d-flex flex-stack flex-wrap gap-3 fs-base fw-semibold mb-8">
                            <div></div>
                            <!--begin::Link-->
                        {{--                            <a href="../../demo2/dist/authentication/layouts/creative/reset-password.html" class="link-primary">Forgot Password ?</a>--}}
                        <!--end::Link-->
                        </div>
                        <!--end::Wrapper-->
                        <!--begin::Submit button-->
                        <div class="d-grid mb-10">
                            <button type="submit" id="sign_in_submit" class="btn btn-primary">
                                <!--begin::Indicator label-->
                                <span class="indicator-label">@lang("Sign In")</span>
                                <!--end::Indicator label-->
                                <!--begin::Indicator progress-->
                                <span class="indicator-progress">Please wait...
										<span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
                                <!--end::Indicator progress-->
                            </button>
                        </div>
                        <!--end::Submit button-->

                    </form>
                    <!--end::Form-->
                </div>
                <!--end::Wrapper-->

            </div>
            <!--end::Card-->
        </div>
        <!--end::Body-->
        <!--begin::Aside-->
        <div class="d-flex flex-center w-lg-50 pt-15 pt-lg-0 px-10">
            <!--begin::Aside-->
            <div class="d-flex flex-center flex-lg-start flex-column">
                <!--begin::Logo-->
{{--                <a href="../../demo2/dist/index.html" class="mb-7">--}}
                    <img alt="Logo" src="logo.png" width="500" />
{{--                </a>--}}
                <!--end::Logo-->
                <!--begin::Title-->
                <h2 class="text-white fw-normal m-0 w-100 text-center">AAH HR Admin Panel</h2>
                <!--end::Title-->
            </div>
            <!--begin::Aside-->
        </div>
        <!--begin::Aside-->
    </div>
    <!--end::Authentication - Sign-up-->
    @push('page-script')
        <script type="text/javascript">
            // Define form element
            const form = document.getElementById('login');

            // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
            var validator = FormValidation.formValidation(
                form,
                {
                    fields: {
                        'username': {
                            validators: {
                                notEmpty: {
                                    message: 'Username is required'
                                }
                            }
                        },
                        'password': {
                            validators: {
                                notEmpty: {
                                    message: 'Password is required'
                                }
                            }
                        },
                    },

                    plugins: {
                        trigger: new FormValidation.plugins.Trigger(),
                        bootstrap: new FormValidation.plugins.Bootstrap5({
                            rowSelector: '.fv-row',
                            eleInvalidClass: '',
                            eleValidClass: ''
                        })
                    }
                }
            );
            // Submit button handler
            const submitButton = document.getElementById('sign_in_submit');
            submitButton.addEventListener('click', function (e) {
                // Prevent default button action
                e.preventDefault();

                // Validate form before submit
                if (validator) {
                    validator.validate().then(function (status) {
                        console.log('validated!');

                        if (status == 'Valid') {
                            // Show loading indication
                            submitButton.setAttribute('data-kt-indicator', 'on');

                            // Disable button to avoid multiple click
                            submitButton.disabled = true;

                            jQuery.ajaxSetup({
                                headers: {
                                    'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
                                }
                            });
                            jQuery.ajax({
                                url: '{{ route($postRoute) }}' ,
                                type: "POST",
                                data: jQuery('#login').serialize(),
                            })
                                .done (function( response ) {
                                    console.log('mzh');
                                    console.log(response);
                                    if(response.hasOwnProperty("success") && response.success === false) {
                                        // Remove loading indication
                                        submitButton.removeAttribute('data-kt-indicator');
                                        // Enable button
                                        submitButton.disabled = false;
                                        // Show popup confirmation
                                        Swal.fire({
                                            text: response.message,
                                            icon: "error",
                                            buttonsStyling: false,
                                            confirmButtonText: "Ok",
                                            customClass: {
                                                confirmButton: "btn btn-primary"
                                            }
                                        });
                                    }else if(response.hasOwnProperty("success") && response.success === true){
                                        // Remove loading indication
                                        submitButton.removeAttribute('data-kt-indicator');
                                        // Enable button
                                        submitButton.disabled = false;
                                        // Show popup confirmation
                                        Swal.fire({
                                            text: "Logged in successfully",
                                            icon: "success",
                                            timer: 2000,
                                            buttons: false,
                                            // buttonsStyling: false,
                                            // confirmButtonText: "Ok, got it!",
                                            // customClass: {
                                            //     confirmButton: "btn btn-primary"
                                            // }
                                        }).then((result) => {
                                            location.href = '{{$redirectTo}}';
                                            {{--dispatch(redirect('{{$redirectTo}}'));--}}
                                            {{--                                            location.href = '{{route('backend.dashboard')}}';--}}
                                        });
                                        // $('.print-error-msg').hide().find('ul').empty();
                                        // var info = $('.print-success-msg');
                                        // info.hide().find('ul').empty();
                                        // info.find('ul').append('<li><i class="material-icons">success</i>' + response.message + '</li>');
                                        // info.slideDown();

                                    }
                                    console.log(response);
                                })
                                .fail(function (jqXHR, textStatus, errorThrown) {
                                    // error_div.show();
                                    // error_div.html('<label class="error">'+jqXHR.responseJSON.msg+'</label>');
                                    // Remove loading indication
                                    submitButton.removeAttribute('data-kt-indicator');
                                    // Enable button
                                    submitButton.disabled = false;
                                    // Show popup confirmation
                                    Swal.fire({
                                        text: jqXHR,
                                        icon: "error",
                                        buttonsStyling: false,
                                        confirmButtonText: "Ok",
                                        customClass: {
                                            confirmButton: "btn btn-primary"
                                        }
                                    });
                                    // console.log(jqXHR);
                                });

                        }
                    });
                }
            });
        </script>
    @endpush
@endsection
