@extends('layouts.vertical.master')
@section('content')
    <!--begin::Content container-->
    <div id="kt_app_content_container" class="app-container container-xxl">
    @include('components.success-msg')
    @include('components.error-msg')
    <!--begin::Card-->
        <div class="card">
            <!--begin::Card body-->
            <div class="card-body">
                <form class="form" name="create_task" id="create_task_form" method="POST" enctype="multipart/form-data" action="@if($user->id > 0){{route('users.update', ['user' => $user->id])}}@else{{route('users.create')}}@endif">
                @csrf
                <!--begin::Card-->
                    <div class="card">
                        <!--begin::Card header-->
                        <div class="card-header">
                            <!--begin::Card header-->
                            @if($user->id > 0)
                                <div class="card-title fs-3 fw-bold">Update User {{$user->username}}</div>
                            @else
                                <div class="card-title fs-3 fw-bold">Create New User</div>
                            @endif
                            <!--end::Card header-->
                        </div>
                        <!--end::Card header-->
                        <!--begin::Card body-->
                        <div class="card-body">
                            <!--begin::Row-->
                            <div class="row mb-8">
                                <!--begin::Col-->
                                <div class="col-xl-2">
                                    <div class="fs-6 fw-semibold mt-2 mb-3">@lang("Full Name")*</div>
                                </div>
                                <!--end::Col-->
                                <!--begin::Col-->
                                {{--                                @include('components.input_error')--}}
                                <div class="col-xl-4">
                                    <input name="full_name" class="form-control form-control-solid" type="text" id="full_name" value="{{$user->full_name}}" required>
                                </div>
                                <!--end::Col-->
                                <!--begin::Col-->
                                <div class="col-xl-2">
                                    <div class="fs-6 fw-semibold mt-2 mb-3">@lang("Email")</div>
                                </div>
                                <!--end::Col-->
                                <!--begin::Col-->
                                {{--                                @include('components.input_error')--}}
                                <div class="col-xl-4">
                                    <input name="email" class="form-control form-control-solid" type="text" id="email"  value="{{$user->email}}">
                                </div>
                                <!--end::Col-->
                            </div>
                            <!--end::Row-->
                            <!--begin::Row-->
                            <div class="row mb-8">
                                <!--begin::Col-->
                                <div class="col-xl-2">
                                    <div class="fs-6 fw-semibold mt-2 mb-3">@lang("Username")*</div>
                                </div>
                                <!--end::Col-->
                                <!--begin::Col-->
                                {{--                                @include('components.input_error')--}}
                                <div class="col-xl-4">
                                    <input name="username" class="form-control form-control-solid" type="text" id="username" autocomplete="off"  value="{{$user->username}}" @if($user->id > 0) disabled @else required @endif>
                                </div>
                                <!--end::Col-->
                                <!--begin::Col-->
                                <div class="col-xl-2">
                                    <div class="fs-6 fw-semibold mt-2 mb-3">@lang("Password")*</div>
                                </div>
                                <!--end::Col-->
                                <!--begin::Col-->
                                {{--                                @include('components.input_error')--}}
                                <div class="col-xl-4">
                                    <input name="password" class="form-control form-control-solid" type="password" id="password" autocomplete="off" value="{{$user->password}}" required>
                                </div>
                                <!--end::Col-->
                            </div>
                            <!--end::Row-->
                            <!--begin::Row-->
{{--                            <div class="row mb-8">--}}
{{--                                <!--begin::Col-->--}}
{{--                                <div class="col-xl-2">--}}
{{--                                    <div class="fs-6 fw-semibold mt-2 mb-3">Status</div>--}}
{{--                                </div>--}}
{{--                                <!--end::Col-->--}}
{{--                                <!--begin::Col-->--}}
{{--                                <div class="col-xl-4">--}}
{{--                                    <!--begin::Wrapper-->--}}
{{--                                    <div class="d-flex fw-semibold h-100">--}}
{{--                                        <!--begin::Checkbox-->--}}
{{--                                        <div class="form-check form-check-custom form-check-solid me-9">--}}
{{--                                            <input class="form-check-input" type="checkbox" value="" id="email">--}}
{{--                                            <label class="form-check-label ms-3" for="email">Active</label>--}}
{{--                                        </div>--}}
{{--                                        <!--end::Checkbox-->--}}
{{--                                        --}}{{--                                        <!--begin::Checkbox-->--}}
{{--                                        --}}{{--                                        <div class="form-check form-check-custom form-check-solid">--}}
{{--                                        --}}{{--                                            <input class="form-check-input" type="checkbox" value="" id="phone" checked="checked">--}}
{{--                                        --}}{{--                                            <label class="form-check-label ms-3" for="phone">Phone</label>--}}
{{--                                        --}}{{--                                        </div>--}}
{{--                                        --}}{{--                                        <!--end::Checkbox-->--}}
{{--                                    </div>--}}
{{--                                    <!--end::Wrapper-->--}}
{{--                                </div>--}}
{{--                                <!--end::Col-->--}}
{{--                            </div>--}}
                            <!--end::Row-->
                            <!--begin::Row-->
                            <div class="row mb-8">
                                <!--begin::Col-->
                                <div class="col-xl-2">
                                    <div class="fs-6 fw-semibold mt-2 mb-3">@lang("Role")*</div>
                                </div>
                                <!--end::Col-->
                                <!--begin::Col-->
                                {{--                                @include('components.input_error')--}}
                                <div class="col-xl-4">
                                    <select name="role_id" class="form-select form-control-solid" id="role_id" required>
                                        @foreach($roles as $role)
                                            <option value="{{$role->id}}" @if($role->id == $user->role_id) selected @endif>{{$role->defaultLang->role_name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <!--end::Col-->
                                <!--begin::Col-->
                                <div class="col-xl-2">
                                    <div class="fs-6 fw-semibold mt-2 mb-3">@lang("Governorate")*</div>
                                </div>
                                <!--end::Col-->
                                <!--begin::Col-->
                                {{--                                @include('components.input_error')--}}
                                <div class="col-xl-4">
                                    <select name="gov_id" class="form-select form-control-solid" id="gov_id" required>
                                        @foreach($governorates as $gov)
                                            <option value="{{$gov->id}}" @if($gov->id == $user->gov_id) selected @endif>{{$gov->defaultLang->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <!--end::Col-->
                            </div>
                        <!--end::Row-->
                            <!--begin::Row-->
                            <div class="row mb-8">
                                <!--begin::Col-->
                                <div class="col-xl-2">
                                    <div class="fs-6 fw-semibold mt-2 mb-3">@lang("Status")</div>
                                </div>
                                <!--end::Col-->
                                <!--begin::Col-->
                                <div class="col-xl-4">
                                    <!--begin::Switch-->
                                    <div class="form-check form-switch form-check-custom form-check-solid">
                                        <input class="form-check-input" type="checkbox" name="is_active" value="1" id="is_active" @if($user->is_active == 1)  checked="checked" @endif >
                                        <label class="form-check-label fw-semibold text-gray-400 ms-3" for="is_active">@lang("Active")</label>
                                    </div>
                                    <!--end::Switch-->
                                </div>
                                <!--end::Col-->
                            </div>
                            <!--end::Row-->
                        </div>
                        <!--end::Card body-->
                        <!--begin::Card footer-->
                        <div class="card-footer d-flex justify-content-end py-6">
                            <button type="reset" class="btn btn-light btn-active-light-primary me-2">Discard</button>
                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>
                        <!--end::Card footer-->
                    </div>
                    <!--end::Card-->
                </form>
            </div>
            <!--end::Card body-->
        </div>
        <!--end::Card-->
    </div>
    <!--end::Content container-->
@endsection
