@extends('layouts.vertical.master')
@section('content')
    <!--begin::Content container-->
    <div id="kt_app_content_container" class="app-container container-xxl">
        <div class="card mb-5">
            <div class="card-header">
                <!--begin::Header-->
                <div class="px-7 py-5">
                    <div class="fs-5 text-dark fw-bold">Filter Options</div>
                </div>
                <!--end::Header-->
            </div>
            <div class="card-body  js-datatable-filter-form">
                <!--begin::Form-->
                <div class="px-7 py-5 row d-flex flex-row">
                    <!--begin::Input group-->
                    <div class="col-md-4 mb-10">
                        <!--begin::Label-->
                        <label class="form-label fw-semibold" for="gov_id">Governorate:</label>
                        <!--end::Label-->
                        <!--begin::Input-->
                        <div>
                            <select name="gov_id" class="form-select form-control-solid select2" id="gov_id" required>
                                <option value="">@lang("Select Governorate")</option>
                                @foreach($governorates as $gov)
                                    <option value="{{$gov->id}}" @if($gov->id == request()->gov_id) selected @endif>{{$gov->defaultLang->name}}</option>
                                @endforeach
                            </select>
                        </div>
                        <!--end::Input-->
                    </div>
                    <!--end::Input group-->
                    <!--begin::Input group-->
                    <div class="col-md-4 mb-10" id="kt_menu_64b77b0e7d45b">
                        <!--begin::Label-->
                        <label class="form-label fw-semibold" for="employee">Employee:</label>
                        <!--end::Label-->
                        <!--begin::Input-->
                        <div>
                            {{--                            <select class="form-select form-select-solid" name="employee" id="employee" multiple="multiple" >--}}
                            <select name="employee" class="form-select form-control-solid" id="employee" multiple="multiple" data-kt-select2="true" data-close-on-select="false" data-placeholder="Select option" data-dropdown-parent="#kt_menu_64b77b0e7d45b" data-allow-clear="true">
                                {{--                            <select class="form-select form-select-solid" name="employee" multiple="multiple" data-kt-select2="true" data-close-on-select="false" data-placeholder="Select option" data-dropdown-parent="#kt_menu_64b77b0e7d45b" data-allow-clear="true">--}}
                                <option></option>
                                @foreach($employees as $employee)
                                    <option value="{{$employee->id}}">{{\App\Models\User::getDecryptedData($employee->full_name)}}</option>
                                @endforeach
                            </select>
                        </div>
                        <!--end::Input-->
                    </div>
                    <!--end::Input group-->
                </div>
                <!--end::Form-->
            </div>
        </div>
        <div class="container">
            <div class="card mb-5 mb-xl-8">
                <div class="card-header border-0 pt-5">
                    <h3 class="card-title align-items-start flex-column">
                        <span class="card-label fw-bold fs-3 mb-1">Manage Users</span>
                    </h3>
                    @if(auth()->guard('admin')->user()->role_id == \App\Models\Role::ADMIN_ROLE)
                    <div class="card-toolbar">
                        <a class="btn btn-flex btn-primary" href="{{route('users.add')}}">
                            <i class="ki-outline ki-plus fs-2"></i>Add User</a>
                    </div>
                    @endif
                </div>
                <div class="card-body">
                    {{ $dataTable->table() }}
                </div>
            </div>
        </div>
    </div>
    <!--end::Content container-->
@endsection

@push('scripts')
    {{ $dataTable->scripts(attributes: ['type' => 'module']) }}
    @include('components.datatable.buttons-script')
    <script>
        $(document).ready(function () {
            $('.js-datatable-filter-form :input').on('change', function (e) {
                window.LaravelDataTables["user-table"].draw();
            });
            $('.js-datatable-filter-form :input').on('keyup', function (e) {
                window.LaravelDataTables["user-table"].draw();
            });

            $('#user-table').on('preXhr.dt', function ( e, settings, data ) {
                $('.js-datatable-filter-form :input').each(function () {
                    data[$(this).prop('name')] = $(this).val();
                });
            });
        });
    </script>

@endpush
