@extends('layouts.vertical.master')
@section('content')
    <!--begin::Content container-->
    <div id="kt_app_content_container" class="app-container container-xxl">
    @include('components.success-msg')
    @include('components.error-msg')
    <!--begin::Card-->
        <div class="card">
            <!--begin::Card body-->
            <div class="card-body">
                <form class="form" name="edit_profile" id="edit_profile" method="POST" enctype="multipart/form-data" action="{{route('admin.save-profile')}}">
                @csrf
                <!--begin::Card-->
                    <div class="card">
                        <!--begin::Card header-->
                        <div class="card-header">
                            <!--begin::Card header-->
                            <div class="card-title fs-3 fw-bold">Edit Profile</div>
                            <!--end::Card header-->
                        </div>
                        <!--end::Card header-->
                        <!--begin::Card body-->
                        <div class="card-body">
                            <!--begin::Row-->
                            <div class="row mb-8 fv-row">
                                <!--begin::Col-->
                                <div class="col-xl-3">
                                    <div class="fs-6 fw-semibold mt-2 mb-3">Current Password</div>
                                </div>
                                <!--end::Col-->
                                <!--begin::Col-->
                                {{--                                @include('components.input_error')--}}
                                <div class="col-xl-9">
                                    <input name="current_password" class="form-control form-control-solid" type="password" id="current_password">
                                </div>
                                <!--end::Col-->
                            </div>
                            <!--end::Row-->
                            <!--begin::Row-->
                            <div class="row mb-8 fv-row">
                                <!--begin::Col-->
                                <div class="col-xl-3">
                                    <div class="fs-6 fw-semibold mt-2 mb-3">New Password</div>
                                </div>
                                <!--end::Col-->
                                <!--begin::Col-->
                                {{--                                @include('components.input_error')--}}
                                <div class="col-xl-9">
                                    <input name="password" class="form-control form-control-solid" type="password" id="password">
                                </div>
                                <!--end::Col-->
                            </div>
                            <!--end::Row-->
                            <!--begin::Row-->
                            <div class="row mb-8 fv-row">
                                <!--begin::Col-->
                                <div class="col-xl-3">
                                    <div class="fs-6 fw-semibold mt-2 mb-3">Confirm Password</div>
                                </div>
                                <!--end::Col-->
                                <!--begin::Col-->
                                {{--                                @include('components.input_error')--}}
                                <div class="col-xl-9">
                                    <input name="confirm_password" class="form-control form-control-solid" type="password" id="confirm_password">
                                </div>
                                <!--end::Col-->
                            </div>
                            <!--end::Row-->
                        </div>
                        <!--end::Card body-->
                        <!--begin::Card footer-->
                        <div class="card-footer d-flex justify-content-end py-6">
                            <button type="reset" class="btn btn-light btn-active-light-primary me-2">Discard</button>
                            <!--begin::Submit button-->
                            <button type="submit" id="save_profile_button" class="btn btn-primary">
                                <!--begin::Indicator label-->
                                <span class="indicator-label">@lang("Save")</span>
                                <!--end::Indicator label-->
                                <!--begin::Indicator progress-->
                                <span class="indicator-progress">Please wait...
                                    <span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
                                <!--end::Indicator progress-->
                            </button>
                            <!--end::Submit button-->
                        </div>
                        <!--end::Card footer-->
                    </div>
                    <!--end::Card-->
                </form>
            </div>
            <!--end::Card body-->
        </div>
        <!--end::Card-->
    </div>
    <!--end::Content container-->
@endsection

@push('page-script')
    <script type="text/javascript">
        // Define form element
        const form = document.getElementById('edit_profile');

        // Init form validation rules. For more info check the FormValidation plugin's official documentation:https://formvalidation.io/
        var validator = FormValidation.formValidation(
            form,
            {
                fields: {
                    'current_password': {
                        validators: {
                            notEmpty: {
                                message: 'Current Password is required'
                            }
                        }
                    },
                    'password': {
                        validators: {
                            notEmpty: {
                                message: 'Password is required'
                            }
                        }
                    },
                    'confirm_password': {
                        validators: {
                            notEmpty: {
                                message: 'Confirm password is required'
                            }
                        }
                    },
                },

                plugins: {
                    trigger: new FormValidation.plugins.Trigger(),
                    bootstrap: new FormValidation.plugins.Bootstrap5({
                        rowSelector: '.fv-row',
                        eleInvalidClass: '',
                        eleValidClass: ''
                    })
                }
            }
        );
        // Submit button handler
        const submitButton = document.getElementById('save_profile_button');
        submitButton.addEventListener('click', function (e) {
            // Prevent default button action
            e.preventDefault();

            // Validate form before submit
            if (validator) {
                validator.validate().then(function (status) {
                    console.log('validated!');

                    if (status == 'Valid') {
                        // Show loading indication
                        submitButton.setAttribute('data-kt-indicator', 'on');

                        // Disable button to avoid multiple click
                        submitButton.disabled = true;

                        jQuery.ajaxSetup({
                            headers: {
                                'X-CSRF-TOKEN': jQuery('meta[name="csrf-token"]').attr('content')
                            }
                        });
                        jQuery.ajax({
                            url: '{{route('admin.save-profile')}}' ,
                            type: "POST",
                            data: jQuery('#edit_profile').serialize(),
                        })
                            .done (function( response ) {
                                if(response.hasOwnProperty("error")) {
                                    // Remove loading indication
                                    submitButton.removeAttribute('data-kt-indicator');
                                    // Enable button
                                    submitButton.disabled = false;
                                    // Show popup confirmation
                                    Swal.fire({
                                        text: response.message,
                                        icon: "error",
                                        buttonsStyling: false,
                                        confirmButtonText: "Ok",
                                        customClass: {
                                            confirmButton: "btn btn-primary"
                                        }
                                    });
                                }else{
                                    // Remove loading indication
                                    submitButton.removeAttribute('data-kt-indicator');
                                    // Enable button
                                    submitButton.disabled = false;
                                    // Show popup confirmation
                                    Swal.fire({
                                        text: "Password Updated Successfully",
                                        icon: "success",
                                        timer: 2000,
                                        buttons: false,
                                        // buttonsStyling: false,
                                        // confirmButtonText: "Ok, got it!",
                                        // customClass: {
                                        //     confirmButton: "btn btn-primary"
                                        // }
                                    }).then((result) => {
                                        location.reload();
                                    });

                                }
                                console.log(response);
                            })
                            .fail(function (jqXHR, textStatus, errorThrown) {
                                Swal.fire({
                                    text: jqXHR,
                                    icon: "error",
                                    buttonsStyling: false,
                                    confirmButtonText: "Ok",
                                    customClass: {
                                        confirmButton: "btn btn-primary"
                                    }
                                })
                            });

                    }
                });
            }
        });
    </script>
@endpush
