@extends('layouts.vertical.master')

@section('page-title', "User " . $user->full_name)

@section('content')
    <!--begin::Content container-->
    <div id="kt_app_content_container" class="app-container container-xxl">
        @include('components.success-msg')
        @include('components.error-msg')
        <div class="card mb-10">
            <div class="card-body pt-9 pb-0">
                <!--begin::Details-->
                <div class="d-flex flex-wrap flex-sm-nowrap mb-6">
                    <!--begin::Wrapper-->
                    <div class="flex-grow-1">
                        <!--begin::Head-->
                        <div class="d-flex justify-content-between align-items-start flex-wrap mb-2">
                            <!--begin::Details-->
                            <div class="d-flex flex-column">
                                <!--begin::Status-->
                                <div class="d-flex align-items-center mb-1">
                                    <a href="#" class="text-gray-800 text-hover-primary fs-2 fw-bold me-3">User {{\App\Models\User::getDecryptedData($user->full_name)}}</a>
                                    @if($session->start_date != null)
                                        @if($session->end_date == null)
                                            <span class="badge badge-light-success me-auto">@lang("Active")</span>
                                        @else
                                            <span class="badge badge-light-danger me-auto">@lang("Finished")</span>
                                        @endif
                                    @else
                                        <span class="badge badge-light-danger me-auto">@lang("Absent")</span>
                                    @endif


                                </div>
                                <!--end::Status-->
                                <!--begin::Description-->
                                <div class="d-flex flex-wrap fw-semibold mb-4 fs-5 text-gray-400">Session Date {{$session->created_at != null ? $session->start_date->format('Y-m-d'):'N/A'}}</div>
                                <!--end::Description-->
                            </div>
                            <!--end::Details-->
                            <!--begin::Actions-->
                            <div class="d-flex mb-4">


                            </div>
                            <!--end::Actions-->
                        </div>
                        <!--end::Head-->
                        <!--begin::Info-->
                        <div class="d-flex flex-wrap justify-content-start">
                            <!--begin::Stats-->
                            <div class="d-flex flex-wrap">
                                <!--begin::Stat-->
                                <div class="border border-gray-300 border-dashed rounded
                                  @if($session->start_date != null && $session->start_online == 1)
                                    alert alert-success
                                  @elseif($session->start_date != null && $session->start_online == 0)
                                    alert alert-danger
                                  @endif
                                 min-w-125px py-3 px-4 me-6 mb-3">
                                    <!--begin::Number-->
                                    <div class="d-flex align-items-center">
                                        <div class="fs-4 fw-bold">
{{--                                            @if($task->result != \App\Models\Task::TASK_STATUS_PENDING)--}}
{{--                                                {{$task->start_time}}--}}
{{--                                            @else--}}
{{--                                                {{$task->task_date}}--}}
{{--                                            @endif--}}
                                            {{$session->start_date != null ? $session->start_date->format('H:i:s'):"N/A"}}
                                        </div>
                                    </div>
                                    <!--end::Number-->
                                    <!--begin::Label-->
                                    <div class="fw-semibold fs-6 text-gray-400">
                                        @lang("Start Time")
                                    </div>
                                    <!--end::Label-->
                                </div>
                                <!--end::Stat-->
                                <!--begin::Stat-->
                                <div class="border border-gray-300 border-dashed rounded
                                 @if($session->end_date != null && $session->end_online == 1)
                                    alert alert-success
                                  @elseif($session->end_date != null && $session->end_online == 0)
                                    alert alert-danger
                                  @endif
                                 min-w-125px py-3 px-4 me-6 mb-3">
                                    <!--begin::Number-->
                                    <div class="d-flex align-items-center">
                                        <div class="fs-4 fw-bold">
                                            {{--                                            @if($task->result != \App\Models\Task::TASK_STATUS_PENDING)--}}
                                            {{--                                                {{$task->start_time}}--}}
                                            {{--                                            @else--}}
                                            {{--                                                {{$task->task_date}}--}}
                                            {{--                                            @endif--}}
                                            {{$session->end_date != null ? $session->end_date->format('H:i:s'):"N/A"}}
                                        </div>
                                    </div>
                                    <!--end::Number-->
                                    <!--begin::Label-->
                                    <div class="fw-semibold fs-6 text-gray-400">
                                        @lang("End Time")
                                    </div>
                                    <!--end::Label-->
                                </div>
                                <!--end::Stat-->


                            </div>
                            <!--end::Stats-->
                        </div>
                        <!--end::Info-->
                    </div>
                    <!--end::Wrapper-->
                </div>
                <!--end::Details-->
                <div class="separator"></div>

            </div>
        </div>

        <!--begin::Card-->
        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <!--begin::Card header-->
                    <div class="card-header">
                        <!--begin::Card header-->
                        <div class="card-title fs-3 fw-bold">@lang("Start Location")</div>
                        <!--end::Card header-->
                    </div>
                    <!--end::Card header-->
                    <!--begin::Card body-->
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div id="map" class="map"></div>
{{--                                <div class="google-map">--}}
{{--                                    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2990.274257380938!2d-70.56068388481569!3d41.45496659976631!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89e52963ac45bbcb%3A0xf05e8d125e82af10!2sDos%20Mas!5e0!3m2!1sen!2sus!4v1671220374408!5m2!1sen!2sus" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>--}}
{{--                                </div>--}}
                            </div>
                        </div>
                    </div>
                    <!--end::Card body-->
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <!--begin::Card header-->
                    <div class="card-header">
                        <!--begin::Card header-->
                        <div class="card-title fs-3 fw-bold">@lang("End Location")</div>
                        <!--end::Card header-->
                    </div>
                    <!--end::Card header-->
                    <!--begin::Card body-->
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div id="map2" class="map"></div>
{{--                                <div class="google-map">--}}
{{--                                    <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2990.274257380938!2d-70.56068388481569!3d41.45496659976631!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x89e52963ac45bbcb%3A0xf05e8d125e82af10!2sDos%20Mas!5e0!3m2!1sen!2sus!4v1671220374408!5m2!1sen!2sus" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>--}}
{{--                                </div>--}}
                            </div>
                        </div>
                    </div>
                    <!--end::Card body-->
                </div>
            </div>
        </div>

        <!--end::Card-->
    </div>
    <!--end::Content container-->
@endsection
@push('page-script')
    <script type="text/javascript">
        const myLatLng = { lat: {!! $startLocation[0] !!}, lng: {!! $startLocation[1] !!} };
        const myLatLng2 = { lat: {!! $endLocation[0] !!}, lng: {!! $endLocation[1] !!} };
        function initLeafletMap() {
            @if($session->start_location != null)
            var map = new L.Map('map');
            // var mutant = L.gridLayer.googleMutant({type: 'satellite'}).addTo(map);
            // var esriAerial = L.tileLayer("https://server.arcgisonline.com/ArcGIS/rest/services/World_Imagery/MapServer/tile/{z}/{y}/{x}", {
            //     maxZoom: 20, maxNativeZoom: 19
            // });
            // L.control.layers({google: mutant, esri: esriAerial}, {}, {collapsed: false}).addTo(map);
            L.tileLayer('https://tile.openstreetmap.org/{z}/{x}/{y}.png', {
                maxZoom: 19,
                attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'
            }).addTo(map);
            L.marker({lat: {{$startLocation[0]}}, lon: {{$startLocation[1]}}}).addTo(map);
            map.setView({lat: {{$startLocation[0]}}, lon: {{$startLocation[1]}}}, 18);
            @endif

            @if($session->end_location != null)
            var map2 = new L.Map('map2');
            // var mutant2 = L.gridLayer.googleMutant({type: 'satellite'}).addTo(map2);
            L.tileLayer('https://tile.openstreetmap.org/{z}/{x}/{y}.png', {
                maxZoom: 19,
                attribution: '&copy; <a href="http://www.openstreetmap.org/copyright">OpenStreetMap</a>'
            }).addTo(map2);
            L.marker({lat: {{$endLocation[0]}}, lon: {{$endLocation[1]}}}).addTo(map2);
            map2.setView({lat: {{$endLocation[0]}}, lon: {{$endLocation[1]}}}, 18);
            @endif
        }
        $(document).ready(function(){
            initLeafletMap();
        });
    </script>
    <script type="text/javascript">
        function initMap() {
            const myLatLng = { lat: {!! $startLocation[0] !!}, lng: {!! $startLocation[1] !!} };
            const myLatLng2 = { lat: {!! $endLocation[0] !!}, lng: {!! $endLocation[1] !!} };
            @if($session->start_location != null)
            const map = new google.maps.Map(document.getElementById("map"), {
                zoom: 18,
                center: myLatLng,
            });
            const marker1 = new google.maps.Marker({
                position: myLatLng,
                map,
                title: "Start Location",
            });
            @endif

            // map.addMarker(marker1);
            @if($session->end_location != null)
                const map2 = new google.maps.Map(document.getElementById("map2"), {
                    zoom: 18,
                    center: myLatLng2,
                });

                var marker = new google.maps.Marker({
                    position: myLatLng2,
                    map: map2,
                    title: 'Hello World!'
                });
            @endif

            // const marker2 = new google.maps.Marker({
            //     position: myLatLng2,
            //     map2,
            //     title: "End Location",
            // });

            // map2.addMarker(marker2);

        }

        window.initMap = initMap;
    </script>

{{--    <script type="text/javascript"--}}
{{--            src="https://maps.google.com/maps/api/js?key={{ env('GOOGLE_MAP_KEY') }}&callback=initMap" ></script>--}}

@endpush
