@extends('layouts.vertical.master')

@section('page-title', "User " . $user->full_name)

@section('content')
    <!--begin::Content container-->
    <div id="kt_app_content_container" class="app-container container-xxl">
        @include('components.success-msg')
        @include('components.error-msg')
        <div class="card mb-10">
            <div class="card-body pt-9 pb-0">
                <!--begin::Details-->
                <div class="d-flex flex-wrap flex-sm-nowrap mb-6">
                    <!--begin::Wrapper-->
                    <div class="flex-grow-1">
                        <!--begin::Head-->
                        <div class="d-flex justify-content-between align-items-start flex-wrap mb-2">
                            <!--begin::Details-->
                            <div class="d-flex flex-column">
                                <!--begin::Status-->
                                <div class="d-flex align-items-center mb-1">
                                    <a href="#" class="text-gray-800 text-hover-primary fs-2 fw-bold me-3">User {{\App\Models\User::getDecryptedData($user->full_name)}}</a>
                                    @if($user->is_active == 1)
                                        <span class="badge badge-light-success me-auto">@lang("Active")</span>
                                    @else
                                        <span class="badge badge-light-danger me-auto">@lang("Inactive")</span>
                                    @endif

                                </div>
                                <!--end::Status-->
                                <!--begin::Description-->
                                <div class="d-flex flex-wrap fw-semibold mb-4 fs-5 text-gray-400">Created {{$user->created_at != null ? $user->created_at->format('Y-m-d H:i:s'):'N/A'}}</div>
                                <!--end::Description-->
                            </div>
                            <!--end::Details-->
                            <!--begin::Actions-->
                            <div class="d-flex mb-4">

                                <a class="btn btn-sm btn-success me-3" id="edit-user" href="{{route('users.edit', ['user' => $user->id])}}">
                                    <!--begin::Indicator label-->
                                    <span class="indicator-label">@lang("Edit User")</span>
                                    <!--end::Indicator label-->
                                    <!--begin::Indicator progress-->
                                    <span class="indicator-progress">Please wait...
										<span class="spinner-border spinner-border-sm align-middle ms-2"></span></span>
                                    <!--end::Indicator progress-->

                                </a>
                            </div>
                            <!--end::Actions-->
                        </div>
                        <!--end::Head-->
                        <!--begin::Info-->
                        <div class="d-flex flex-wrap justify-content-start">
                            <!--begin::Stats-->
                            <div class="d-flex flex-wrap">
                                <!--begin::Stat-->
                                <div class="border border-gray-300 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                    <!--begin::Number-->
                                    <div class="d-flex align-items-center">
                                        <div class="fs-4 fw-bold">
{{--                                            @if($task->result != \App\Models\Task::TASK_STATUS_PENDING)--}}
{{--                                                {{$task->start_time}}--}}
{{--                                            @else--}}
{{--                                                {{$task->task_date}}--}}
{{--                                            @endif--}}
                                            {{\App\Models\User::getActiveSession($user->id)->start_date ?? "N/A"}}
                                        </div>
                                    </div>
                                    <!--end::Number-->
                                    <!--begin::Label-->
                                    <div class="fw-semibold fs-6 text-gray-400">
                                        @lang("Active From")
                                    </div>
                                    <!--end::Label-->
                                </div>
                                <!--end::Stat-->
                                <!--begin::Stat-->
                                <div class="border border-gray-300 border-dashed rounded min-w-125px py-3 px-4 me-6 mb-3">
                                    <!--begin::Number-->
                                    <div class="d-flex align-items-center">
                                        <i class="ki-outline ki-tablet-ok fs-3 text-success me-2"></i>
                                        <div class="fs-4 fw-bold counted" data-kt-countup="true" data-kt-countup-value="75" data-kt-initialized="1">{{$user->user_work_sessions->count()}}</div>
                                    </div>
                                    <!--end::Number-->
                                    <!--begin::Label-->
                                    <div class="fw-semibold fs-6 text-gray-400">@lang("Logged Sessions")</div>
                                    <!--end::Label-->
                                </div>
                                <!--end::Stat-->


                            </div>
                            <!--end::Stats-->
                        </div>
                        <!--end::Info-->
                    </div>
                    <!--end::Wrapper-->
                </div>
                <!--end::Details-->
                <div class="separator"></div>

            </div>
        </div>

        <!--begin::Card-->
        <div class="card">
            <!--begin::Card header-->
            <div class="card-header">
                <!--begin::Card header-->
                <div class="card-title fs-3 fw-bold">@lang("Latest Sessions")</div>
                <!--end::Card header-->
            </div>
            <!--end::Card header-->
            <!--begin::Card body-->
            <div class="card-body">
                <!--begin::Row-->
                <div class="row mb-8">
                    {{ $dataTable->table() }}
                </div>
                <!--end::Row-->
            </div>
            <!--end::Card body-->
        </div>
        <!--end::Card-->
    </div>
    <!--end::Content container-->
@endsection
@push('scripts')
    {{ $dataTable->scripts(attributes: ['type' => 'module']) }}
    @include('components.datatable.buttons-script')

@endpush
