<?php

use App\Http\Controllers\Api\ApiMainController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::post('employee-login', [ApiMainController::class, 'employeeLogin']);
Route::post('employee-logout', [ApiMainController::class, 'employeeLogout'])->name('employee-logout');
Route::post('employee-change-password', [ApiMainController::class, 'changePassword'])->name('employee-change-password');

Route::post('start-work-session', [ApiMainController::class, 'startWorkSession'])->name('start-work-session');
Route::post('finish-work-session', [ApiMainController::class, 'finishWorkSession'])->name('finish-work-session');
Route::post('sync-offline-sessions', [ApiMainController::class, 'syncOfflineSession'])->name('sync-offline-sessions');

Route::post('change-password', [ApiMainController::class, 'changePassword'])->name('change-password');
Route::post('get-work-sessions', [ApiMainController::class, 'getWorkSessions'])->name('get-work-sessions');
