<?php

use App\Http\Controllers\DashboardController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\UserController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/login', [LoginController::class ,'adminLogin'])->name('login');
Route::post('/do-login', [LoginController::class ,'login'])->name('admin.doLogin');

Route::group(['middleware' => ['auth:admin']],function() {
    Route::get('logout',[LoginController::class, 'logout'])->name('admin.logout');
//    Route::get('lang/{locale}',[LanguageController::class,'swap']);

    //User Profile
    Route::get('profile', [DashboardController::class, 'profile'])->name('admin.profile');
    Route::post('save-profile', [DashboardController::class, 'saveProfile'])->name('admin.save-profile');


    //Home
    Route::get('/', [DashboardController::class, 'dashboard'])->name( 'admin.home');
    Route::get('dashboard', [DashboardController::class, 'dashboard'])->name('admin.dashboard');


    Route::get('users', [UserController::class, 'index'])->name('users.index');
    Route::get('users/add', [UserController::class, 'add'])->name('users.add');
    Route::post('users/create', [UserController::class, 'create'])->name('users.create');
    Route::get('users/view/{user}', [UserController::class, 'view'])->name('users.view');
    Route::get('users/edit/{user}', [UserController::class, 'edit'])->name('users.edit');
    Route::post('users/update/{user}', [UserController::class, 'update'])->name('users.update');
    Route::post('users/delete/{user}', [UserController::class, 'delete'])->name('users.delete');
    Route::get('users/datatables', 'UserController@datatables')->name('users.datatables');

    Route::get('users/view-session/{session}', [UserController::class, 'viewSession'])->name('users.view-session');
    Route::get('users/sessions', [UserController::class, 'sessionsIndex'])->name('users.sessions');

//    Route::get('users/attendance-report', [UserController::class, 'attendanceReport'])->name('users.attendance-report');
    Route::get('users/daily-report', [UserController::class, 'dailyReport'])->name('users.daily-reports');
    Route::get('users/daily-report/export', [UserController::class, 'exportDailySessions'])->name('users.export-daily-report');



});


