<script>
    $(document).on('click', '.ajax-button', function (e) {
        e.preventDefault();
        var id = $(this).data('id');
        var url = $(this).data('route');
        var loading = $("#overlay");
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        Swal.fire({
            text: "Are you sure?",
            icon: "warning",
            showCancelButton: true,
            buttonsStyling: false,
            showLoaderOnConfirm: true,
            confirmButtonText: "Yes!",
            cancelButtonText: "No, cancel",
            customClass: {
                confirmButton: "btn fw-bold btn-danger",
                cancelButton: "btn fw-bold btn-active-light-primary"
            },
        }).then(function (result) {
            showLoading();
            if (result.value) {
                // Simulate delete request -- for demo purpose only
                $("#overlay").fadeIn(300);
                $.ajax({
                    type: "POST",
                    url: url,
                    data: {id:id},
                    success: function (data) {
                        loading.fadeOut(300);
                        hideLoading();
                        console.log(data.success);
                        console.log(data.message);
                        if(data.success == true){
                            Swal.fire({
                                text: data.message,
                                icon: "success",
                                buttonsStyling: false,
                                confirmButtonText: "Ok, got it!",
                                customClass: {
                                    confirmButton: "btn fw-bold btn-primary",
                                }
                            }).then(function () {
                                // delete row data from server and re-draw datatable
                                location.reload();
                            });
                        }else{
                            swal.fire(data.message);
                        }
                    },
                    error: function() {
                        loading.fadeOut(300);
                        hideLoading();
                    }
                });
            } else if (result.dismiss === 'cancel') {
                Swal.fire({
                    text: "Selected data was not deleted.",
                    icon: "error",
                    buttonsStyling: false,
                    confirmButtonText: "Ok, got it!",
                    customClass: {
                        confirmButton: "btn fw-bold btn-primary",
                    }
                });
            }
        });


        swalWithBootstrapButtons({
            title: "Are you sure?",
            text: "Are you sure you want to delete?",
            type: 'warning',
            showCancelButton: true,
            confirmButtonText: "<?php echo app('translator')->get('Yes Sure'); ?>",
            cancelButtonText: "<?php echo app('translator')->get('No Cancel'); ?>",
            reverseButtons: true
        }).then((result) => {
            if (result.value) {
                $("#overlay").fadeIn(300);
                showLoading();
                $.ajax({
                    type: "POST",
                    url: url,
                    data: {id:id},
                    success: function (data) {
                        loading.fadeOut(300);
                        hideLoading();
                        if(data.success == true){
                            swal(data.message).then((result) => {
                                location.reload();
                            });
                        }else{
                            swal(data.message);
                        }
                    },
                    error: function() {
                        loading.fadeOut(300);
                        hideLoading();
                    }
                });
            } else if (
                // Read more about handling dismissals
                result.dismiss === Swal.DismissReason.cancel

            ) {
                result.dismiss === Swal.DismissReason.cancel;
                $("#overlay").fadeOut(300);
                hideLoading();
            }
        })
    });
</script>
<?php /**PATH /home/jwqp6t0r49ya/aah.techbithub.com/techbithub/resources/views/components/datatable/buttons-script.blade.php ENDPATH**/ ?>